local sceneEnvironment = require('demosceneEnvironment')
scene = {}

function generateFlightTrajectory(model, speed, targetOffset)
	sceneAPI:addFlightController(model)
	sceneAPI:setUpdateFunc('mainThemeSceneUpdate')
	local ctrl = model.controller
	ctrl:setSpeed(speed) -- /
	ctrl:setTargetOffset(targetOffset) --    ,    	
	local ang=0
	local radius=0
	for i=0, 9, 1 do
		ang = (i/10)*6.2832 --2pi
		radius = 23000*(1+math.random(-40, 40)/100)
		ctrl:addKnot(math.sin(ang)*radius, 1500 + math.random(-1000, 1000), math.cos(ang)*radius);
	end
	local x,y,z = ctrl:getKnot(0)
	ctrl:addKnot(x,y,z);
end

function loadScene(scenePtr)
	sceneAPI = sceneEnvironment.getInterface(scenePtr)
	sceneAPI:setCloudsDensity(1)
	sceneAPI:setCirrus(true)	
	sceneAPI:setLensEffects(true)
	
	scene.cam = sceneAPI:addCamera(0, 0, 0)	
	scene.cam:setFarClip(23000*3)
	
	-- --Su-27
	-- scene.su27 = sceneAPI:addModel("su-27", 0, 0, 0)
	-- scene.su27.transform:scale(250,250,250)
	-- generateFlightTrajectory(scene.su27, 6000, 800)
	-- scene.cam:attachTo(scene.su27, "Pylon1")
	-- -- --external
	-- scene.cam.transform:move(.1,1.2,5.2)	
	-- -- --cockpit
	-- -- scene.cam.transform:move(9.7,1.60,7.32)	
	
	
	-- -- F-15
	-- scene.f15 = sceneAPI:addModel("f-15", 0, 0, 0)
	-- scene.f15.transform:scale(250,250,250)
	-- generateFlightTrajectory(scene.f15, 7500, 800)
	-- scene.cam:attachTo(scene.f15, "Pylon1")
	-- --external
	-- scene.cam.transform:move(-5,1,-2);	
	-- scene.cam.transform:setOrient(-90,0,0);
	
	-- -- F-18
	scene.f18 = sceneAPI:addModel("f-18c", 0, 0, 0)
	scene.f18.transform:scale(250,250,250)
	generateFlightTrajectory(scene.f18, 7500, 800)
	scene.cam:attachTo(scene.f18, "Pylon1")
	-- -- external
	scene.cam.transform:move(-4,3,-1.1);	
	scene.cam.transform:setOrient(-90,0,0);
	

	
end


function mainThemeSceneUpdate(t, dt)
end



